/* eslint-disable max-len */
define([
    'backbone',
    'Layout',
    'modules/community-care-request/new-appointment-request-question/service-distance-selection/service-section-view',
], function(Backbone, Layout, ServiceSectionView) {
    'use strict';

    describe('Service View Section', function() {
        var view;
        var model = new Backbone.Model({steps: [1]});
        var collection = new Backbone.Collection(
            [
                {
                    name: 'ONE VAMC',
                    testItem: 'PVS-ALPHA-99',
                    facilityCode: '100',
                    supportsVAR: true,
                },
                {
                    name: 'TWO VAMC',
                    testItem: 'PVS-BETA-01',
                    facilityCode: '200',
                    supportsVAR: false,
                },
            ]
        );

        var $view;
        var layout = new Layout();

        layout.render();

        beforeEach(function() {
            view = new ServiceSectionView({
                model: model,
                patientEnrolledFacilities: collection,
            });

            layout.showChildView('content', view);
            $view = view.$el;
        });

        it('shows service options as radio buttons', function() {
            expect(view.collection.get('service').get('type')).toEqual('radio');
        });

        // This unit test will be fixed as part of VAR-13404
        xit('does not show a service unavailable message if the patient has at least 1 facility that supports VAR', function() {
            expect($view.find('label[for="service-community-care-appointments"] .label-text > span').text()).toEqual('Community Care (Distance Eligible Veterans)');
            expect($view.find('label[for="service-community-care-appointments"] .label-details').length).toEqual(0);
        });


        describe('when cc radio button is checked', function() {
            it("sets the model's service to community care", function() {
                view.collection.get('service').set('value', 'Community Care (Distance Eligible Veterans)');
                expect(view.model.get('service')).toEqual('Community Care (Distance Eligible Veterans)');
            });
        });
    });

    describe('Service View Section without supported facilities for CC', function() {
        var view;
        var model = new Backbone.Model({steps: [1]});

        var collection = new Backbone.Collection(
            [
                {
                    name: 'ONE VAMC',
                    testItem: 'PVS-ALPHA-99',
                    facilityCode: '100',
                    supportsVAR: false,
                },
                {
                    name: 'TWO VAMC',
                    testItem: 'PVS-BETA-01',
                    facilityCode: '200',
                    supportsVAR: false,
                },
            ]
        );

        var $view;
        var layout = new Layout();

        layout.render();

        beforeEach(function() {
            view = new ServiceSectionView({
                model: model,
                patientEnrolledFacilities: collection,
            });

            layout.showChildView('content', view);
            $view = view.$el;
        });

        it('shows a community care unavailable message if an option does not support VAR', function() {
            expect($view.find('label[for="service-community-care-appointments"] .label-text > span').text()).toEqual('Community Care (Distance Eligible Veterans)');
        });
    });
});
